package site

import "alpha/adDelivery/deliveryLimitation/validation"
import 	"fmt"
import 	"strings"
import	"github.com/elliotchance/phpserialize"


func Hostnamelist(limitation string,op string,val string) bool {
	
	var r map[interface{}]interface{}
	phpserialize.Unmarshal([]byte(limitation), &r)
	var limitations [] string 
	
	for key, _ := range r {
      keys := fmt.Sprintf("%v", key)
		limitations = append(limitations,keys)
    }
 
	
	result :=  validation.CheckRealArrayValueMatch(limitations,val)
	
	
	switch op {
    case "=~":
        return result
    case "!~":
        return !result
    }
    
    return false
}


func Variable(limitation string,op string,val string) bool {
	
	
	l := strings.Split(limitation, "|") ; 
	variable_val := l[1]
	
	result := validation.CheckStringMatch(val,variable_val)
		
		switch op {

    case "==":
        return result 
    case "!=":
        return !result 
    case "=~":
        return  validation.CheckStringContains(val , variable_val)
    case "!~":
        return !validation.CheckStringContains(val , variable_val)
    case "=x":
        return validation.CheckStringRexMatch(val , variable_val)
    case "!x":
        return !validation.CheckStringRexMatch(val , variable_val) 
    case "lt":
        return validation.CheckStringintLess(val,variable_val)    
    case "gt":
        return validation.CheckStringintGra(val,variable_val)   
    case "le":
        return validation.CheckStringintLessEq(val,variable_val)  
    case "ge":
        return  validation.CheckStringintGraEq(val,variable_val)   
        
    }
    
    return false
}




 

func Registerabledomainlist(limitation string,op string,val string) bool {
	
	var r map[interface{}]interface{}
	phpserialize.Unmarshal([]byte(limitation), &r)
	var limitations [] string 
	
	for key, _ := range r {
      keys := fmt.Sprintf("%v", key)
		limitations = append(limitations,keys)
    }
 
	
	result :=  validation.CheckRealArrayValueMatch(limitations,val)
	
	
	switch op {
    case "=~":
        return result
    case "!~":
        return !result
    }
    
    return false
}



func Pageurl(limitation string,op string,page string) bool {
	
	result := validation.CheckStringMatch(limitation,page)
		
		switch op {
    case "==":
        return result
    case "!=":
        return !result
    case "=~":
        return  validation.CheckStringContains(page , limitation)
    case "!~":
        return !validation.CheckStringContains(page , limitation)
    case "=x":
        return validation.CheckStringRexMatch(page , limitation)
    case "!x":
        return !validation.CheckStringRexMatch(page , limitation) 
  
    }
        return false

} 


func Referingpage(limitation string,op string,ref string) bool {
	
	result := validation.CheckStringMatch(limitation,ref)
		
		switch op {
    case "==":
        return result
    case "!=":
        return !result
    case "=~":
        return  validation.CheckStringContains(ref , limitation)
    case "!~":
        return !validation.CheckStringContains(ref , limitation)
    case "=x":
        return validation.CheckStringRexMatch(ref , limitation)
    case "!x":
        return !validation.CheckStringRexMatch(ref , limitation) 
  
    }
        return false

} 


func Source(limitation string,op string,source string) bool {
	
	result := validation.CheckStringMatch(limitation,source)
		
		switch op {
    case "==":
        return result
    case "!=":
        return !result
    case "=~":
        return  validation.CheckStringContains(source , limitation)
    case "!~":
        return !validation.CheckStringContains(source , limitation)
    case "=x":
        return validation.CheckStringRexMatch(source , limitation)
    case "!x":
        return !validation.CheckStringRexMatch(source , limitation) 
  
    }
        return false

} 
